<?php
/**
 * Plugin Name: Cloudflare Analytics
 * Plugin URI: https://akensai.com
 * Description: Complete Cloudflare analytics dashboard with hourly metrics, top URLs, geographic data, and browser statistics.
 * Version: 1.0.2
 * Author: Akensai
 * Author URI: https://akensai.com
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: cloudflare-analytics
 */

if (!defined('ABSPATH')) {
    exit;
}

// Define plugin constants
define('CF_ANALYTICS_VERSION', '1.0.2');
define('CF_ANALYTICS_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('CF_ANALYTICS_PLUGIN_URL', plugin_dir_url(__FILE__));

// Include required files
require_once CF_ANALYTICS_PLUGIN_DIR . 'includes/class-cf-encryption.php';
require_once CF_ANALYTICS_PLUGIN_DIR . 'includes/class-cf-database.php';
require_once CF_ANALYTICS_PLUGIN_DIR . 'includes/class-cf-api.php';
require_once CF_ANALYTICS_PLUGIN_DIR . 'includes/class-cf-cron.php';

// Admin pages
if (is_admin()) {
    require_once CF_ANALYTICS_PLUGIN_DIR . 'admin/settings.php';
    require_once CF_ANALYTICS_PLUGIN_DIR . 'admin/analytics.php';
    require_once CF_ANALYTICS_PLUGIN_DIR . 'admin/widget.php';
}

// Admin bar (both frontend and backend)
add_action('init', function() {
    if (is_admin_bar_showing()) {
        require_once CF_ANALYTICS_PLUGIN_DIR . 'admin/admin-bar.php';
    }
});

/**
 * Activation hook
 */
register_activation_hook(__FILE__, function() {
    CF_Database::create_tables();
    CF_Cron::schedule_events();
});

/**
 * Deactivation hook
 */
register_deactivation_hook(__FILE__, function() {
    CF_Cron::clear_scheduled_events();
});

/**
 * Add settings link on plugins page
 */
add_filter('plugin_action_links_' . plugin_basename(__FILE__), function($links) {
    $settings_link = '<a href="' . admin_url('admin.php?page=cf-analytics-settings') . '">Settings</a>';
    array_unshift($links, $settings_link);
    return $links;
});
