# Changelog

## [2.0.0] - 2026-01-16

### Added
- **Top URLs Tracking**: Track top 50 URLs per day with requests, visits, and bandwidth
- **Geographic Data**: Country-level traffic analysis with requests, bandwidth, and threats
- **Browser Statistics**: Browser usage breakdown with page view counts
- **Backfill Function**: Import up to 30 days of historical data on setup
- **Tabbed Interface**: Overview, Top Content, Geography, and Technology tabs
- **5 Database Tables**: Optimized storage with hourly, daily, URLs, countries, and browsers tables
- **Daily Sync**: Separate cron job for detailed data (URLs, countries, browsers)
- **Enhanced API**: Multiple GraphQL queries for comprehensive data collection

### Changed
- Complete code restructure with better separation of concerns
- Improved database schema with proper indexing and data types
- Better cron job organization (hourly_sync, daily_sync, daily_cleanup, monthly_optimize)
- Enhanced UI with modern gradient stat cards
- Improved settings page with zone auto-detection
- Better error handling and logging

### Fixed
- DateTime format conversion (ISO 8601 to MySQL)
- Cache hit rate calculation
- Bandwidth display (minimum KB instead of raw bytes)
- Database query optimization
- Memory-efficient backfill process

## [1.0.0] - 2026-01-15

### Added
- Initial release
- Basic time-series metrics (requests, visitors, bandwidth)
- Hourly sync via WordPress cron
- Dashboard widget with 7-day overview
- Simple analytics page with charts
- API credential encryption
